/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.game;

import com.google.common.collect.Lists;
import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.api.GameMode;
import dev.doctor4t.wathe.api.MapEffect;
import dev.doctor4t.wathe.api.event.AllowPlayerDeath;
import dev.doctor4t.wathe.api.event.GameEvents;
import dev.doctor4t.wathe.api.event.ShouldDropOnDeath;
import dev.doctor4t.wathe.cca.GameTimeComponent;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.cca.MapVariablesWorldComponent;
import dev.doctor4t.wathe.cca.PlayerMoodComponent;
import dev.doctor4t.wathe.cca.PlayerNoteComponent;
import dev.doctor4t.wathe.cca.PlayerPoisonComponent;
import dev.doctor4t.wathe.cca.PlayerPsychoComponent;
import dev.doctor4t.wathe.cca.PlayerShopComponent;
import dev.doctor4t.wathe.cca.TrainWorldComponent;
import dev.doctor4t.wathe.cca.WorldBlackoutComponent;
import dev.doctor4t.wathe.compat.TrainVoicePlugin;
import dev.doctor4t.wathe.entity.PlayerBodyEntity;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.index.WatheDataComponentTypes;
import dev.doctor4t.wathe.index.WatheEntities;
import dev.doctor4t.wathe.index.WatheItems;
import dev.doctor4t.wathe.index.WatheSounds;
import dev.doctor4t.wathe.util.AnnounceEndingPayload;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3419;
import net.minecraft.class_3829;
import net.minecraft.class_4538;
import net.minecraft.class_5454;
import net.minecraft.class_5575;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameFunctions {
    public static void limitPlayerToBox(class_3222 player, class_238 box) {
        class_243 playerPos = player.method_19538();
        if (!box.method_1006(playerPos)) {
            double x = playerPos.method_10216();
            double y = playerPos.method_10214();
            double z = playerPos.method_10215();
            if (z < box.field_1321) {
                z = box.field_1321;
            }
            if (z > box.field_1324) {
                z = box.field_1324;
            }
            if (y < box.field_1322) {
                y = box.field_1322;
            }
            if (y > box.field_1325) {
                y = box.field_1325;
            }
            if (x < box.field_1323) {
                x = box.field_1323;
            }
            if (x > box.field_1320) {
                x = box.field_1320;
            }
            player.method_5859(x, y, z);
        }
    }

    public static void startGame(class_3218 world, GameMode gameMode, MapEffect mapEffect, int time) {
        GameWorldComponent game = (GameWorldComponent)GameWorldComponent.KEY.get((Object)world);
        MapVariablesWorldComponent areas = (MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)world);
        int playerCount = Math.toIntExact(world.method_18456().stream().filter(serverPlayerEntity -> areas.getReadyArea().method_1006(serverPlayerEntity.method_19538())).count());
        game.setGameMode(gameMode);
        game.setMapEffect(mapEffect);
        ((GameTimeComponent)GameTimeComponent.KEY.get((Object)world)).setResetTime(time);
        if (playerCount >= gameMode.minPlayerCount) {
            game.setGameStatus(GameWorldComponent.GameStatus.STARTING);
        } else {
            for (class_3222 player : world.method_18456()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"game.start_error.not_enough_players", (Object[])new Object[]{gameMode.minPlayerCount}), true);
            }
        }
    }

    public static void stopGame(class_3218 world) {
        GameWorldComponent component = (GameWorldComponent)GameWorldComponent.KEY.get((Object)world);
        component.setGameStatus(GameWorldComponent.GameStatus.STOPPING);
    }

    public static void initializeGame(class_3218 serverWorld) {
        GameWorldComponent gameComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)serverWorld);
        List<class_3222> readyPlayerList = GameFunctions.getReadyPlayerList(serverWorld);
        ((GameEvents.OnGameStart)GameEvents.ON_GAME_START.invoker()).onGameStart(gameComponent.getGameMode());
        GameFunctions.baseInitialize(serverWorld, gameComponent, readyPlayerList);
        gameComponent.getGameMode().initializeGame(serverWorld, gameComponent, readyPlayerList);
        gameComponent.sync();
        ((GameEvents.OnFinishInitialize)GameEvents.ON_FINISH_INITIALIZE.invoker()).onFinishInitialize((class_1937)serverWorld, gameComponent);
    }

    private static void baseInitialize(class_3218 serverWorld, GameWorldComponent gameComponent, List<class_3222> players) {
        MapVariablesWorldComponent areas = (MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)serverWorld);
        ((WorldBlackoutComponent)WorldBlackoutComponent.KEY.get((Object)serverWorld)).reset();
        ((class_1928.class_4310)serverWorld.method_8450().method_20746(class_1928.field_19389)).method_20758(true, serverWorld.method_8503());
        ((class_1928.class_4310)serverWorld.method_8450().method_20746(class_1928.field_19406)).method_20758(false, serverWorld.method_8503());
        ((class_1928.class_4310)serverWorld.method_8450().method_20746(class_1928.field_19396)).method_20758(false, serverWorld.method_8503());
        ((class_1928.class_4310)serverWorld.method_8450().method_20746(class_1928.field_19388)).method_20758(false, serverWorld.method_8503());
        ((class_1928.class_4310)serverWorld.method_8450().method_20746(class_1928.field_19390)).method_20758(false, serverWorld.method_8503());
        ((class_1928.class_4310)serverWorld.method_8450().method_20746(class_1928.field_19409)).method_20758(false, serverWorld.method_8503());
        ((class_1928.class_4310)serverWorld.method_8450().method_20746(class_1928.field_21832)).method_20758(false, serverWorld.method_8503());
        ((class_1928.class_4312)serverWorld.method_8450().method_20746(class_1928.field_28357)).method_35236(9999, serverWorld.method_8503());
        serverWorld.method_8503().method_3776(class_1267.field_5801, true);
        for (class_3222 player : serverWorld.method_18456()) {
            player.method_29239();
        }
        for (class_3222 player : players) {
            player.method_7336(class_1934.field_9216);
            class_243 pos = player.method_19538().method_1019(class_243.method_24954((class_2382)areas.getPlayAreaOffset()));
            player.method_5859(pos.method_10216(), pos.method_10214() + 1.0, pos.method_10215());
        }
        for (class_3222 player : serverWorld.method_18766(serverPlayerEntity -> !players.contains(serverPlayerEntity))) {
            player.method_7336(class_1934.field_9219);
            MapVariablesWorldComponent.PosWithOrientation spectatorSpawnPos = areas.getSpectatorSpawnPos();
            player.method_14251(serverWorld, spectatorSpawnPos.pos.method_10216(), spectatorSpawnPos.pos.method_10214(), spectatorSpawnPos.pos.method_10215(), spectatorSpawnPos.yaw, spectatorSpawnPos.pitch);
        }
        for (class_3222 serverPlayerEntity2 : players) {
            serverPlayerEntity2.method_31548().method_5448();
            ((PlayerMoodComponent)PlayerMoodComponent.KEY.get((Object)serverPlayerEntity2)).reset();
            ((PlayerShopComponent)PlayerShopComponent.KEY.get((Object)serverPlayerEntity2)).reset();
            ((PlayerPoisonComponent)PlayerPoisonComponent.KEY.get((Object)serverPlayerEntity2)).reset();
            ((PlayerPsychoComponent)PlayerPsychoComponent.KEY.get((Object)serverPlayerEntity2)).reset();
            ((PlayerNoteComponent)PlayerNoteComponent.KEY.get((Object)serverPlayerEntity2)).reset();
            ((PlayerShopComponent)PlayerShopComponent.KEY.get((Object)serverPlayerEntity2)).reset();
            TrainVoicePlugin.resetPlayer(serverPlayerEntity2.method_5667());
            HashSet copy = new HashSet(serverPlayerEntity2.method_7357().field_8024.keySet());
            for (class_1792 item : copy) {
                serverPlayerEntity2.method_7357().method_7900(item);
            }
        }
        gameComponent.clearRoleMap();
        ((GameTimeComponent)GameTimeComponent.KEY.get((Object)serverWorld)).reset();
        gameComponent.queueMapReset();
        gameComponent.getMapEffect().initializeMapEffects(serverWorld, players);
        gameComponent.setGameStatus(GameWorldComponent.GameStatus.ACTIVE);
        gameComponent.sync();
    }

    private static List<class_3222> getReadyPlayerList(class_3218 serverWorld) {
        MapVariablesWorldComponent areas = (MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)serverWorld);
        List players = serverWorld.method_18766(serverPlayerEntity -> areas.getReadyArea().method_1006(serverPlayerEntity.method_19538()));
        return players;
    }

    public static void finalizeGame(class_3218 world) {
        GameWorldComponent gameComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)world);
        ((GameEvents.OnGameStop)GameEvents.ON_GAME_STOP.invoker()).onGameStop(gameComponent.getGameMode());
        gameComponent.getGameMode().finalizeGame(world, gameComponent);
        ((WorldBlackoutComponent)WorldBlackoutComponent.KEY.get((Object)world)).reset();
        TrainWorldComponent trainComponent = (TrainWorldComponent)TrainWorldComponent.KEY.get((Object)world);
        trainComponent.setSpeed(0);
        trainComponent.setTimeOfDay(TrainWorldComponent.TimeOfDay.DAY);
        for (PlayerBodyEntity body : world.method_18198(WatheEntities.PLAYER_BODY, playerBodyEntity -> true)) {
            body.method_31472();
        }
        for (class_1297 entity2 : world.method_18198(WatheEntities.FIRECRACKER, entity -> true)) {
            entity2.method_31472();
        }
        for (class_1297 entity2 : world.method_18198(WatheEntities.NOTE, entity -> true)) {
            entity2.method_31472();
        }
        for (class_3222 player : world.method_18456()) {
            GameFunctions.resetPlayer(player);
        }
        ((GameTimeComponent)GameTimeComponent.KEY.get((Object)world)).reset();
        gameComponent.clearRoleMap();
        gameComponent.setGameStatus(GameWorldComponent.GameStatus.INACTIVE);
        trainComponent.setTime(0);
        gameComponent.sync();
        ((GameEvents.OnFinishFinalize)GameEvents.ON_FINISH_FINALIZE.invoker()).onFinishFinalize((class_1937)world, gameComponent);
    }

    public static void resetPlayer(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new AnnounceEndingPayload());
        player.method_29239();
        player.method_31548().method_5448();
        ((PlayerMoodComponent)PlayerMoodComponent.KEY.get((Object)player)).reset();
        ((PlayerShopComponent)PlayerShopComponent.KEY.get((Object)player)).reset();
        ((PlayerPoisonComponent)PlayerPoisonComponent.KEY.get((Object)player)).reset();
        ((PlayerPsychoComponent)PlayerPsychoComponent.KEY.get((Object)player)).reset();
        ((PlayerNoteComponent)PlayerNoteComponent.KEY.get((Object)player)).reset();
        TrainVoicePlugin.resetPlayer(player.method_5667());
        player.method_7336(class_1934.field_9216);
        player.method_18400();
        MapVariablesWorldComponent.PosWithOrientation spawnPos = ((MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)player.method_37908())).getSpawnPos();
        class_5454 teleportTarget = new class_5454(player.method_51469(), spawnPos.pos, class_243.field_1353, spawnPos.yaw, spawnPos.pitch, class_5454.field_52245);
        player.method_5731(teleportTarget);
    }

    public static boolean isPlayerEliminated(class_1657 player) {
        return player == null || !player.method_5805() || player.method_7337() || player.method_7325();
    }

    public static void killPlayer(class_1657 victim, boolean spawnBody, @Nullable class_1657 killer) {
        GameFunctions.killPlayer(victim, spawnBody, killer, GameConstants.DeathReasons.GENERIC);
    }

    public static void killPlayer(class_1657 victim, boolean spawnBody, @Nullable class_1657 killer, class_2960 deathReason) {
        Object body;
        class_3222 serverPlayerEntity;
        PlayerPsychoComponent component = (PlayerPsychoComponent)PlayerPsychoComponent.KEY.get((Object)victim);
        if (!((AllowPlayerDeath)AllowPlayerDeath.EVENT.invoker()).allowDeath(victim, killer, deathReason)) {
            return;
        }
        if (component.getPsychoTicks() > 0) {
            if (component.getArmour() > 0) {
                component.setArmour(component.getArmour() - 1);
                component.sync();
                victim.method_17356(WatheSounds.ITEM_PSYCHO_ARMOUR, class_3419.field_15250, 5.0f, 1.0f);
                return;
            }
            component.stopPsycho();
        }
        if (!(victim instanceof class_3222) || !GameFunctions.isPlayerAliveAndSurvival((class_1657)(serverPlayerEntity = (class_3222)victim))) {
            return;
        }
        serverPlayerEntity.method_7336(class_1934.field_9219);
        if (killer != null) {
            if (((GameWorldComponent)GameWorldComponent.KEY.get((Object)killer.method_37908())).canUseKillerFeatures(killer)) {
                ((PlayerShopComponent)PlayerShopComponent.KEY.get((Object)killer)).addToBalance(100);
            }
            for (List list : killer.method_31548().field_7543) {
                for (class_1799 stack : list) {
                    Boolean used = (Boolean)stack.method_57824(WatheDataComponentTypes.USED);
                    if (!stack.method_31574(WatheItems.DERRINGER) || used == null || !used.booleanValue()) continue;
                    stack.method_57379(WatheDataComponentTypes.USED, (Object)false);
                    killer.method_17356(WatheSounds.ITEM_DERRINGER_RELOAD, class_3419.field_15248, 1.0f, 1.0f);
                }
            }
        }
        ((PlayerMoodComponent)PlayerMoodComponent.KEY.get((Object)victim)).reset();
        if (spawnBody && (body = (PlayerBodyEntity)WatheEntities.PLAYER_BODY.method_5883(victim.method_37908())) != null) {
            ((PlayerBodyEntity)((Object)body)).setPlayerUuid(victim.method_5667());
            class_243 spawnPos = victim.method_19538().method_1019(victim.method_5720().method_1029().method_1021(1.0));
            body.method_5808(spawnPos.method_10216(), victim.method_23318(), spawnPos.method_10215(), victim.method_5791(), 0.0f);
            body.method_36456(victim.method_5791());
            body.method_5847(victim.method_5791());
            victim.method_37908().method_8649((class_1297)body);
        }
        for (List list : victim.method_31548().field_7543) {
            for (int i = 0; i < list.size(); ++i) {
                class_1799 stack;
                stack = (class_1799)list.get(i);
                if (!GameFunctions.shouldDropOnDeath(stack, victim)) continue;
                victim.method_7329(stack, true, false);
                list.set(i, class_1799.field_8037);
            }
        }
        GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)victim.method_37908());
        if (gameWorldComponent.isInnocent(victim)) {
            ((GameTimeComponent)GameTimeComponent.KEY.get((Object)victim.method_37908())).addTime(GameConstants.TIME_ON_CIVILIAN_KILL);
        }
        TrainVoicePlugin.addPlayer(victim.method_5667());
    }

    public static boolean shouldDropOnDeath(@NotNull class_1799 stack, class_1657 victim) {
        return !stack.method_7960() && (stack.method_31574(WatheItems.REVOLVER) || ((ShouldDropOnDeath)ShouldDropOnDeath.EVENT.invoker()).shouldDrop(stack, victim));
    }

    public static boolean isPlayerAliveAndSurvival(class_1657 player) {
        return player != null && !player.method_7325() && !player.method_7337();
    }

    public static boolean isPlayerSpectatingOrCreative(class_1657 player) {
        return player != null && (player.method_7325() || player.method_7337());
    }

    public static boolean tryResetTrain(class_3218 serverWorld) {
        if (serverWorld.method_8503().method_30002().equals(serverWorld)) {
            MapVariablesWorldComponent areas = (MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)serverWorld);
            class_2338 backupMinPos = class_2338.method_49638((class_2374)areas.getResetTemplateArea().method_61125());
            class_2338 backupMaxPos = class_2338.method_49638((class_2374)areas.getResetTemplateArea().method_61126());
            class_3341 backupTrainBox = class_3341.method_34390((class_2382)backupMinPos, (class_2382)backupMaxPos);
            class_2338 trainMinPos = class_2338.method_49638((class_2374)areas.getResetTemplateArea().method_997(class_243.method_24954((class_2382)areas.getResetPasteOffset())).method_61125());
            class_2338 trainMaxPos = trainMinPos.method_10081(backupTrainBox.method_14659());
            class_3341 trainBox = class_3341.method_34390((class_2382)trainMinPos, (class_2382)trainMaxPos);
            Mode mode = Mode.FORCE;
            if (serverWorld.method_22343(backupMinPos, backupMaxPos) && serverWorld.method_22343(trainMinPos, trainMaxPos)) {
                ArrayList list = Lists.newArrayList();
                ArrayList list2 = Lists.newArrayList();
                ArrayList list3 = Lists.newArrayList();
                LinkedList deque = Lists.newLinkedList();
                class_2338 blockPos5 = new class_2338(trainBox.method_35415() - backupTrainBox.method_35415(), trainBox.method_35416() - backupTrainBox.method_35416(), trainBox.method_35417() - backupTrainBox.method_35417());
                for (int k = backupTrainBox.method_35417(); k <= backupTrainBox.method_35420(); ++k) {
                    for (int l = backupTrainBox.method_35416(); l <= backupTrainBox.method_35419(); ++l) {
                        for (int m = backupTrainBox.method_35415(); m <= backupTrainBox.method_35418(); ++m) {
                            class_2338 blockPos6 = new class_2338(m, l, k);
                            class_2338 blockPos7 = blockPos6.method_10081((class_2382)blockPos5);
                            class_2694 cachedBlockPosition = new class_2694((class_4538)serverWorld, blockPos6, false);
                            class_2680 blockState = cachedBlockPosition.method_11681();
                            class_2586 blockEntity = serverWorld.method_8321(blockPos6);
                            if (blockEntity != null) {
                                BlockEntityInfo blockEntityInfo = new BlockEntityInfo(blockEntity.method_58692((class_7225.class_7874)serverWorld.method_30349()), blockEntity.method_58693());
                                list2.add(new BlockInfo(blockPos7, blockState, blockEntityInfo));
                                deque.addLast(blockPos6);
                                continue;
                            }
                            if (!blockState.method_26216((class_1922)serverWorld, blockPos6) && !blockState.method_26234((class_1922)serverWorld, blockPos6)) {
                                list3.add(new BlockInfo(blockPos7, blockState, null));
                                deque.addFirst(blockPos6);
                                continue;
                            }
                            list.add(new BlockInfo(blockPos7, blockState, null));
                            deque.addLast(blockPos6);
                        }
                    }
                }
                ArrayList list4 = Lists.newArrayList();
                list4.addAll(list);
                list4.addAll(list2);
                list4.addAll(list3);
                List list5 = Lists.reverse((List)list4);
                for (BlockInfo blockInfo : list5) {
                    class_2586 blockEntity3 = serverWorld.method_8321(blockInfo.pos);
                    class_3829.method_16825((Object)blockEntity3);
                    serverWorld.method_8652(blockInfo.pos, class_2246.field_10499.method_9564(), 2);
                }
                int mx = 0;
                for (BlockInfo blockInfo2 : list4) {
                    if (!serverWorld.method_8652(blockInfo2.pos, blockInfo2.state, 2)) continue;
                    ++mx;
                }
                for (BlockInfo blockInfo2x : list2) {
                    class_2586 blockEntity4 = serverWorld.method_8321(blockInfo2x.pos);
                    if (blockInfo2x.blockEntityInfo != null && blockEntity4 != null) {
                        blockEntity4.method_58691(blockInfo2x.blockEntityInfo.nbt, (class_7225.class_7874)serverWorld.method_30349());
                        blockEntity4.method_58684(blockInfo2x.blockEntityInfo.components);
                        blockEntity4.method_5431();
                    }
                    serverWorld.method_8652(blockInfo2x.pos, blockInfo2x.state, 2);
                }
                for (BlockInfo blockInfo2x : list5) {
                    serverWorld.method_8408(blockInfo2x.pos, blockInfo2x.state.method_26204());
                }
                serverWorld.method_14196().method_48167(serverWorld.method_14196(), backupTrainBox, (class_2382)blockPos5);
                if (mx == 0) {
                    Wathe.LOGGER.info("Train reset failed: No blocks copied. Queueing another attempt.");
                    return true;
                }
            } else {
                Wathe.LOGGER.info("Train reset failed: Clone positions not loaded. Queueing another attempt.");
                return true;
            }
            for (PlayerBodyEntity body : serverWorld.method_18198(WatheEntities.PLAYER_BODY, playerBodyEntity -> true)) {
                body.method_31472();
            }
            for (class_1542 item : serverWorld.method_18198((class_5575)class_1299.field_6052, playerBodyEntity -> true)) {
                item.method_31472();
            }
            for (class_1297 entity2 : serverWorld.method_18198(WatheEntities.FIRECRACKER, entity -> true)) {
                entity2.method_31472();
            }
            for (class_1297 entity2 : serverWorld.method_18198(WatheEntities.NOTE, entity -> true)) {
                entity2.method_31472();
            }
            Wathe.LOGGER.info("Train reset successful.");
            return false;
        }
        return false;
    }

    public static int getReadyPlayerCount(class_1937 world) {
        List players = world.method_18456();
        MapVariablesWorldComponent areas = (MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)world);
        return Math.toIntExact(players.stream().filter(p -> areas.getReadyArea().method_1006(p.method_19538())).count());
    }

    static enum Mode {
        FORCE(true),
        MOVE(true),
        NORMAL(false);

        private final boolean allowsOverlap;

        private Mode(boolean allowsOverlap) {
            this.allowsOverlap = allowsOverlap;
        }

        public boolean allowsOverlap() {
            return this.allowsOverlap;
        }
    }

    record BlockEntityInfo(class_2487 nbt, class_9323 components) {
    }

    record BlockInfo(class_2338 pos, class_2680 state, @Nullable BlockEntityInfo blockEntityInfo) {
    }

    public static enum WinStatus {
        NONE,
        KILLERS,
        PASSENGERS,
        TIME,
        LOOSE_END;

    }
}

